<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Resultados del Formulario</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #eef6f0;
      padding: 30px;
    }

    .container {
      background-color: #fff;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
      max-width: 800px;
      margin: auto;
    }

    h1 {
      text-align: center;
      color: #2c5d3f;
    }

    .dato {
      margin: 15px 0;
      padding: 10px;
      background-color: #f4f9f6;
      border-left: 5px solid #4CAF50;
    }

    .dato strong {
      color: #333;
    }
  </style>
</head>
<body>

<div class="container">
  <h1>Datos Recibidos</h1>

  <?php
  // Función para limpiar datos
  function limpiar($dato) {
    return htmlspecialchars(trim($dato));
  }

  // Verificamos si se recibió algo por POST
  if ($_SERVER["REQUEST_METHOD"] === "POST") {
    echo "<div class='dato'><strong>Nombre de usuario:</strong> " . limpiar($_POST["username"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Contraseña:</strong> " . limpiar($_POST["psw"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Género:</strong> " . limpiar($_POST["gender"] ?? '') . "</div>";

    // Checkbox: puede haber múltiples valores
    if (!empty($_POST["vehicle"])) {
      $vehiculos = array_map("limpiar", $_POST["vehicle"]);
      echo "<div class='dato'><strong>Vehículos:</strong> " . implode(", ", $vehiculos) . "</div>";
    }

    echo "<div class='dato'><strong>Email:</strong> " . limpiar($_POST["email"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Teléfono:</strong> " . limpiar($_POST["telefono"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Fecha de nacimiento:</strong> " . limpiar($_POST["birthday"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Color favorito:</strong> " . limpiar($_POST["favcolor"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Página web:</strong> " . limpiar($_POST["homepage"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Búsqueda en Google:</strong> " . limpiar($_POST["googlesearch"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Hora seleccionada:</strong> " . limpiar($_POST["usr_time"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Mes y Año:</strong> " . limpiar($_POST["monthYear"] ?? '') . "</div>";
    echo "<div class='dato'><strong>Puntuación:</strong> " . limpiar($_POST["points"] ?? '') . "</div>";

    // Puedes agregar más campos según lo necesites
  } else {
    echo "<p>No se recibieron datos.</p>";
  }
  ?>
  <?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nombre = $_POST['username'];
    $contrasena = $_POST['psw'];
    $genero = $_POST['gender'];
    $vehiculos = isset($_POST['vehicle']) ? implode(", ", $_POST['vehicle']) : 'Ninguno';
    $correo = $_POST['email'];
    $telefono = $_POST['telefono'];
    $fecha = $_POST['birthday'];
    $color = $_POST['favcolor'];
    $busqueda = $_POST['googlesearch'];
    $satisfaccion = $_POST['points'];
    $hora = $_POST['usr_time'];
    $mesanio = $_POST['monthYear'];

    // Crea o agrega al archivo
    $archivo = fopen("datos_guardados.txt", "a");
    fwrite($archivo, "Nombre: $nombre\n");
    fwrite($archivo, "Contraseña: $contrasena\n");
    fwrite($archivo, "Género: $genero\n");
    fwrite($archivo, "Vehículos: $vehiculos\n");
    fwrite($archivo, "Correo: $correo\n");
    fwrite($archivo, "Teléfono: $telefono\n");
    fwrite($archivo, "Fecha de nacimiento: $fecha\n");
    fwrite($archivo, "Color favorito: $color\n");
    fwrite($archivo, "Búsqueda: $busqueda\n");
    fwrite($archivo, "Nivel satisfacción: $satisfaccion\n");
    fwrite($archivo, "Hora preferida: $hora\n");
    fwrite($archivo, "Mes y año: $mesanio\n");
    fwrite($archivo, "-------------------------\n");
    fclose($archivo);

    echo "<h2>Datos guardados exitosamente ✅</h2>";
    echo "<a href='index.html'>Volver al formulario</a>";
}
?>

</div>

</body>
</html>
